<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json");
require_once '../dbconn.php';

define("HTTP_METHOD", $_SERVER['REQUEST_METHOD']);

if (HTTP_METHOD === 'POST') {
    if (!isset($_POST['sub_category_id'], $_POST['sku'], $_POST['name'], $_POST['description'], $_POST['price'], $_POST['stock_quantity'])) {
        echo json_encode(["success" => false, "error" => "Missing required fields"]);
        exit;
    }

    $id = isset($_POST['id']) ? intval($_POST['id']) : null;
    $sub_category_id = intval($_POST['sub_category_id']);
    $sku = mysqli_real_escape_string($conn, $_POST['sku']);
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);
    $price = floatval($_POST['price']);
    $stock_quantity = intval($_POST['stock_quantity']);
    $weight = isset($_POST['weight']) ? floatval($_POST['weight']) : null;
    $size = isset($_POST['size']) ? mysqli_real_escape_string($conn, $_POST['size']) : null;
    $width = isset($_POST['width']) ? floatval($_POST['width']) : null;
    $height = isset($_POST['height']) ? floatval($_POST['height']) : null;
    $slot_width = isset($_POST['slot_width']) ? floatval($_POST['slot_width']) : null;
    $coating = isset($_POST['coating']) ? mysqli_real_escape_string($conn, $_POST['coating']) : null;
    $is_default = isset($_POST['is_default']) ? intval($_POST['is_default']) : 0;
    $material = isset($_POST['material']) ? mysqli_real_escape_string($conn, $_POST['material']) : null;
    $making = isset($_POST['making']) ? mysqli_real_escape_string($conn, $_POST['making']) : null;
    $updated_at = date('Y-m-d H:i:s');

    $image_url = null;
    if (!empty($_FILES['image']['name'])) {
        $target_dir = "uploads/";
        $image_name = basename($_FILES["image"]["name"]);
        $target_file = $target_dir . time() . "_" . $image_name;

        if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
            $image_url = "/Admin/products/" . $target_file;
        } else {
            echo json_encode(["success" => false, "error" => "Failed to upload image"]);
            exit;
        }
    }

    if ($id) {
        // Update existing product
        $query = "UPDATE products SET sub_category_id = ?, sku = ?, name = ?, description = ?, price = ?, stock_quantity = ?, weight = ?, size = ?, width = ?, height = ?, slot_width = ?, coating = ?, is_default = ?, material = ?, making = ?, updated_at = ?";
        if ($image_url) {
            $query .= ", image_url = ?";
        }
        $query .= " WHERE id = ?";

        $stmt = $conn->prepare($query);
        if ($image_url) {
            $stmt->bind_param("isssdiisssdsissssi", $sub_category_id, $sku, $name, $description, $price, $stock_quantity, $weight, $size, $width, $height, $slot_width, $coating, $is_default, $material, $making, $updated_at, $image_url, $id);
        } else {
            $stmt->bind_param("isssdiisssdsisssi", $sub_category_id, $sku, $name, $description, $price, $stock_quantity, $weight, $size, $width, $height, $slot_width, $coating, $is_default, $material, $making, $updated_at, $id);
        }
    } else {
        // Insert new product
        $query = "INSERT INTO products (sub_category_id, sku, name, description, price, stock_quantity, weight, size, width, height, slot_width, coating, is_default, material, making, image_url, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("isssdiisssdsissss", $sub_category_id, $sku, $name, $description, $price, $stock_quantity, $weight, $size, $width, $height, $slot_width, $coating, $is_default, $material, $making, $image_url, $updated_at);
    }

    if ($stmt->execute()) {
        $response = [
            "success" => true,
            "message" => $id ? "Product updated successfully" : "Product added successfully",
            "data" => [
                "id" => $id ? $id : $stmt->insert_id,
                "sub_category_id" => $sub_category_id,
                "sku" => $sku,
                "name" => $name,
                "image_url" => $image_url,
                "description" => $description,
                "price" => $price,
                "stock_quantity" => $stock_quantity,
                "weight" => $weight,
                "size" => $size,
                "width" => $width,
                "height" => $height,
                "slot_width" => $slot_width,
                "coating" => $coating,
                "is_default" => $is_default,
                "material" => $material,
                "making" => $making,
                "updated_at" => $updated_at
            ]
        ];
        echo json_encode($response);
    } else {
        echo json_encode(["success" => false, "error" => "Failed to save product"]);
    }

    $stmt->close();
} else {
    echo json_encode(["success" => false, "error" => "Invalid request method"]);
}

$conn->close();
?>
