<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json");
require_once '../dbconn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_FILES['csv_file'])) {
        echo json_encode(["success" => false, "error" => "CSV file is required"]);
        exit;
    }

    $file = $_FILES['csv_file']['tmp_name'];
    if (!file_exists($file) || !is_readable($file)) {
        echo json_encode(["success" => false, "error" => "Failed to read CSV file"]);
        exit;
    }

    $handle = fopen($file, "r");
    if (!$handle) {
        echo json_encode(["success" => false, "error" => "Failed to open CSV file"]);
        exit;
    }

    $header = fgetcsv($handle);
    if (!$header) {
        echo json_encode(["success" => false, "error" => "Invalid CSV format"]);
        exit;
    }

    $success_count = 0;
    $failed_count = 0;
    $errors = [];
    $row_number = 1;

    while (($row = fgetcsv($handle)) !== false) {
        $row_number++;
        if (count($row) !== count($header)) {
            $failed_count++;
            $errors[] = ["row" => $row_number, "message" => "Column mismatch"];
            continue;
        }

        $data = array_combine($header, $row);
        
        // Validate required fields
        if (empty($data['sub_category_id']) || empty($data['sku']) || empty($data['name']) || empty($data['price']) || empty($data['stock_quantity'])) {
            $failed_count++;
            $errors[] = ["row" => $row_number, "message" => "Missing required fields"];
            continue;
        }

        $sub_category_id = intval($data['sub_category_id']);
        $sku = mysqli_real_escape_string($conn, $data['sku']);
        $name = mysqli_real_escape_string($conn, $data['name']);
        $description = isset($data['description']) ? mysqli_real_escape_string($conn, $data['description']) : null;
        $weight = isset($data['weight']) ? floatval($data['weight']) : null;
        $size = isset($data['size']) ? mysqli_real_escape_string($conn, $data['size']) : null;
        $price = floatval($data['price']);
        $stock_quantity = intval($data['stock_quantity']);
        $image_url = isset($data['image_url']) ? mysqli_real_escape_string($conn, $data['image_url']) : null;
        $width = isset($data['width']) ? floatval($data['width']) : null;
        $height = isset($data['height']) ? floatval($data['height']) : null;
        $slot_width = isset($data['slot_width']) ? floatval($data['slot_width']) : null;
        $coating = isset($data['coating']) ? mysqli_real_escape_string($conn, $data['coating']) : null;
        $is_default = isset($data['is_default']) ? intval($data['is_default']) : 0;
        $in_stock = isset($data['in_stock']) ? intval($data['in_stock']) : 1;
        $material = isset($data['material']) ? mysqli_real_escape_string($conn, $data['material']) : null;
        $making = isset($data['making']) ? mysqli_real_escape_string($conn, $data['making']) : null;
        $created_at = isset($data['created_at']) ? $data['created_at'] : date('Y-m-d H:i:s');
        $updated_at = isset($data['updated_at']) ? $data['updated_at'] : date('Y-m-d H:i:s');

        // Insert into database
        $query = "INSERT INTO products (sub_category_id, sku, name, description, weight, size, price, stock_quantity, image_url, width, height, slot_width, coating, is_default, in_stock, material, making, created_at, updated_at)
                  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $stmt = $conn->prepare($query);
        $stmt->bind_param("issssdisssdsiiissss", $sub_category_id, $sku, $name, $description, $weight, $size, $price, $stock_quantity, $image_url, $width, $height, $slot_width, $coating, $is_default, $in_stock, $material, $making, $created_at, $updated_at);

        if ($stmt->execute()) {
            $success_count++;
        } else {
            $failed_count++;
            $errors[] = ["row" => $row_number, "message" => "Database insert failed: " . $stmt->error];
        }

        $stmt->close();
    }

    fclose($handle);
    echo json_encode(["success" => true, "success_count" => $success_count, "failed_count" => $failed_count, "errors" => $errors]);

    $conn->close();
} else {
    echo json_encode(["success" => false, "error" => "Invalid request method"]);
}
?>
