<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header("Content-Type: application/json");
require_once '../dbconn.php';

define("HTTP_METHOD", $_SERVER['REQUEST_METHOD']);

if (HTTP_METHOD === 'POST') {
    if (isset($_POST['id'])) {
        $id = intval($_POST['id']);

        $query = "DELETE FROM categories WHERE id = ?";
        
        try {
            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $id);
            $stmt->execute();

            if ($stmt->affected_rows > 0) {
                echo json_encode([
                    "success" => true,
                    "message" => "Category deleted successfully"
                ]);
            } else {
                echo json_encode([
                    "success" => false,
                    "error" => "Failed to delete category or category not found"
                ]);
            }
            
            $stmt->close();
        } catch (mysqli_sql_exception $e) {
            if (strpos($e->getMessage(), 'foreign key constraint fails') !== false) {
                echo json_encode([
                    "success" => false,
                    "error" => "Cannot delete category: It has associated subcategories. Delete them first."
                ]);
            } else {
                echo json_encode([
                    "success" => false,
                    "error" => "Database error: " . $e->getMessage()
                ]);
            }
        }
    } else {
        echo json_encode([
            "success" => false,
            "error" => "Missing category ID"
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "error" => "Invalid request method"
    ]);
}

$conn->close();
?>
