<?php
header("Content-Type: application/json");
require_once '../dbconn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate and get form data
    $product_id = isset($_POST['product_id']) ? intval($_POST['product_id']) : 0;
    $date_from = isset($_POST['date_from']) ? $_POST['date_from'] : null;
    $date_to = isset($_POST['date_to']) ? $_POST['date_to'] : null;

    if ($product_id <= 0) {
        echo json_encode(["error" => "Invalid or missing product_id"]);
        exit;
    }

    // Build the SQL query with filters
    $query = "SELECT id, product_id, quantity_changed, stock_after_change, change_type, notes, created_at 
              FROM inventory_history 
              WHERE product_id = ?";

    $params = [$product_id];
    $types = "i";

    if ($date_from && $date_to) {
        $query .= " AND created_at BETWEEN ? AND ?";
        $params[] = $date_from;
        $params[] = $date_to;
        $types .= "ss";
    } elseif ($date_from) {
        $query .= " AND created_at >= ?";
        $params[] = $date_from;
        $types .= "s";
    } elseif ($date_to) {
        $query .= " AND created_at <= ?";
        $params[] = $date_to;
        $types .= "s";
    }

    $query .= " ORDER BY created_at DESC";

    // Prepare and execute the query
    $stmt = $conn->prepare($query);
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $result = $stmt->get_result();

    // Fetch and format data
    $history = [];
    while ($row = $result->fetch_assoc()) {
        $history[] = [
            "id" => $row["id"],
            "product_id" => $row["product_id"],
            "quantity_changed" => $row["quantity_changed"],
            "stock_after_change" => $row["stock_after_change"],
            "change_type" => $row["change_type"],
            "notes" => $row["notes"],
            "created_at" => $row["created_at"]
        ];
    }

    $stmt->close();
    $conn->close();

    // Return response
    echo json_encode(["success" => true, "history" => $history]);
} else {
    echo json_encode(["error" => "Invalid request method"]);
}
?>
