<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include '../../dbconn.php'; // Database connection

header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
    exit;
}

// Validate required fields
$required_fields = ['id', 'code', 'type', 'discount_value', 'valid_from', 'valid_until'];
foreach ($required_fields as $field) {
    if (!isset($_POST[$field]) || empty($_POST[$field])) {
        echo json_encode(["success" => false, "message" => "$field is required"]);
        exit;
    }
}

// Get form data
$id = intval($_POST['id']);
$code = trim($_POST['code']);
$type = trim($_POST['type']);
$discount_value = floatval($_POST['discount_value']);
$minimum_purchase = isset($_POST['minimum_purchase']) ? floatval($_POST['minimum_purchase']) : 0;
$maximum_discount = isset($_POST['maximum_discount']) ? floatval($_POST['maximum_discount']) : 0;
$usage_limit = isset($_POST['usage_limit']) ? intval($_POST['usage_limit']) : 0;
$valid_from = trim($_POST['valid_from']);
$valid_until = trim($_POST['valid_until']);
$is_active = isset($_POST['is_active']) ? intval($_POST['is_active']) : 1; // Default to active

// Log received dates for debugging
error_log("Received valid_from: " . $valid_from);
error_log("Received valid_until: " . $valid_until);

// Ensure valid type
if (!in_array($type, ['percentage', 'fixed'])) {
    echo json_encode(["success" => false, "message" => "Invalid type"]);
    exit;
}

// Convert dates to proper format
$valid_from_timestamp = strtotime($valid_from);
$valid_until_timestamp = strtotime($valid_until);

if (!$valid_from_timestamp || !$valid_until_timestamp) {
    echo json_encode([
        "success" => false, 
        "message" => "Invalid date format", 
        "debug" => [
            "valid_from" => $valid_from,
            "valid_until" => $valid_until
        ]
    ]);
    exit;
}

// Format the dates in MySQL format
$valid_from_formatted = date('Y-m-d H:i:s', $valid_from_timestamp);
$valid_until_formatted = date('Y-m-d H:i:s', $valid_until_timestamp);

// Check if promocode exists
$check_query = "SELECT * FROM promocodes WHERE id = ?";
$stmt = $conn->prepare($check_query);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    echo json_encode(["success" => false, "message" => "Promocode not found"]);
    exit;
}

// Update promocode
$update_query = "UPDATE promocodes SET 
    code = ?, 
    type = ?, 
    discount_value = ?, 
    minimum_purchase = ?, 
    maximum_discount = ?, 
    usage_limit = ?, 
    valid_from = ?, 
    valid_until = ?, 
    is_active = ?, 
    updated_at = NOW() 
    WHERE id = ?";

$stmt = $conn->prepare($update_query);
$stmt->bind_param(
    "ssddddssii", 
    $code, 
    $type, 
    $discount_value, 
    $minimum_purchase, 
    $maximum_discount, 
    $usage_limit, 
    $valid_from_formatted, 
    $valid_until_formatted, 
    $is_active, 
    $id
);

if ($stmt->execute()) {
    // Fetch updated data
    $fetch_query = "SELECT * FROM promocodes WHERE id = ?";
    $stmt = $conn->prepare($fetch_query);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $updated_promocode = $stmt->get_result()->fetch_assoc();
    
    echo json_encode([
        "success" => true, 
        "message" => "Promocode updated successfully", 
        "data" => $updated_promocode
    ]);
} else {
    echo json_encode([
        "success" => false, 
        "message" => "Failed to update promocode: " . $conn->error
    ]);
}

$stmt->close();
$conn->close();
?>