<?php
header("Content-Type: application/json");
require_once '../dbconn.php';

// Get query parameters
$status = isset($_GET['status']) ? $_GET['status'] : 'all';
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 10;
$offset = ($page - 1) * $limit;

// Validate status filter
$status_condition = "";
if ($status === "active") {
    $status_condition = "AND is_active = 1"; // AND valid_until >= NOW()
} elseif ($status === "expired") {
    $status_condition = "AND valid_until < NOW()";
}

// Search filter
$search_condition = "";
if (!empty($search)) {
    $search_condition = "AND (code LIKE ?)";
}

// Prepare the SQL query
$query = "SELECT SQL_CALC_FOUND_ROWS * FROM promocodes WHERE 1=1 $status_condition $search_condition LIMIT ?, ?";
$stmt = $conn->prepare($query);

// Bind parameters dynamically
if (!empty($search)) {
    $search_param = "%$search%";
    $stmt->bind_param("sii", $search_param, $offset, $limit);
} else {
    $stmt->bind_param("ii", $offset, $limit);
}

$stmt->execute();
$result = $stmt->get_result();

// Fetch promo codes
$promocodes = [];
while ($row = $result->fetch_assoc()) {
    $promocodes[] = $row;
}

// Get total count for pagination
$total_query = "SELECT FOUND_ROWS() as total";
$total_result = $conn->query($total_query);
$total = $total_result->fetch_assoc()['total'];


// Get statistics about promotions
// 1. Count of active promotions
$active_query = "SELECT COUNT(*) as active_count FROM promocodes WHERE is_active = 1 AND valid_until >= NOW()";
$active_result = $conn->query($active_query);
$active_count = $active_result->fetch_assoc()['active_count'];

// 2. Count of expired promotions
$expired_query = "SELECT COUNT(*) as expired_count FROM promocodes WHERE
        is_active = 0  OR valid_until < NOW()";
$expired_result = $conn->query($expired_query);
$expired_count = $expired_result->fetch_assoc()['expired_count'];

// 3. Total usage of all promotions
$usage_query = "SELECT SUM(times_used) as total_usage FROM promocodes";
$usage_result = $conn->query($usage_query);
$total_usage = $usage_result->fetch_assoc()['total_usage'] ?? 0;

// 4. Average discount across all promotions
$avg_query = "SELECT AVG(discount_amount) as avg_discount FROM promocode_usage";
$avg_result = $conn->query($avg_query);
$avg_discount = $avg_result->fetch_assoc()['avg_discount'] ?? 0;

// Pagination details
$pagination = [
    "total" => $total,
    "page" => $page,
    "limit" => $limit
];

// Statistics
$statistics = [
    "active_promotions" => $active_count,
    "expired_promotions" => $expired_count,
    "total_usage" => $total_usage,
    "avg_discount" => round($avg_discount, 2)
];
 

// Response
$response = [
    "success" => True,
    "data" => [
        "promocodes" => $promocodes,
        "pagination" => $pagination,
        "statistics" => $statistics
    ]
];

echo json_encode($response);

$stmt->close();
$conn->close();
?>
