<?php

// // Set CORS headers BEFORE any output
// header('Access-Control-Allow-Origin: http://localhost:5173');
// header('Access-Control-Allow-Methods: GET, POST, DELETE, OPTIONS');
// header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control');
// header('Access-Control-Allow-Credentials: true'); // optional, only if you're sending cookies or HTTP auth

// // Handle preflight OPTIONS request
// if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
//     http_response_code(204); // No content
//     exit;
// }

header('Content-Type: application/json');
// Autoload Composer packages
require_once '../vendor/autoload.php'; // Adjust the path if needed

// Include the database connection
include '../dbconn.php';

include '../env.php';


use Firebase\JWT\JWT;
use Firebase\JWT\Key;

$mobile = $_POST['mobile'] ?? null;
$password = $_POST['password'] ?? null;

// Initialize response
$response = [
    "status" => "error",
    "message" => "Invalid mobile number or password."
];

// Validate input
if (!$mobile || !$password) {
    $response['message'] = "Mobile number and password are required.";
    echo json_encode($response);
    exit;
}

// Check if the user exists in the database
$query = "SELECT id, name, mobile, email, password_hash FROM users WHERE mobile = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $mobile);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode($response);
    exit;
}

// Fetch user details
$user = $result->fetch_assoc();

// Verify the password
if (!password_verify($password, $user['password_hash'])) {
    echo json_encode($response);
    exit;
}

// Generate JWT token
$issuedAt = time();
$expirationTime = $issuedAt + (60 * 60 * 24); // Token valid for 1 day

$payload = [
    'iss' => 'yourdomain.com', // issuer
    'iat' => $issuedAt,
    'exp' => $expirationTime,
    'sub' => $user['id'],
    'user' => [
        'id' => $user['id'],
        'name' => $user['name'],
        'mobile' => $user['mobile'],
        'email' => $user['email']
    ]
];

$jwt = JWT::encode($payload, $secret_key, 'HS256');

// Successful login response
$response = [
    "status" => "success",
    "message" => "Login successful.",
    "data" => [
        "token" => $jwt,
        'user' => [
        //'id' => $user['id'],
        'name' => $user['name'],
        'mobile' => $user['mobile'],
        'email' => $user['email']
    ]
    ]
];

echo json_encode($response);
$conn->close();
exit;
?>
