<?php
// Set CORS headers BEFORE any output
// header('Access-Control-Allow-Origin: http://localhost:5173');
// header('Access-Control-Allow-Methods: GET, POST, DELETE, OPTIONS');
// header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control');
// header('Access-Control-Allow-Credentials: true'); // optional, only if you're sending cookies or HTTP auth

// Handle preflight OPTIONS request
// if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
//     http_response_code(204); // No content
//     exit;
// }

// header('Content-Type: application/json');
require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    http_response_code(401); // Unauthorized
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);
//$secretKey = "e3ff5f077839c1331b1d893a728246685cb7dba9e3a77bffe7d52eaccf660988";

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null; // Extract user ID from token
    if (!$user_id) {
        http_response_code(400); // Unauthorized
        echo json_encode(['status' => 'error', 'message' => 'Invalid token: user ID not found']);
        exit;
    }
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204); // No Content
    exit();
}

// Get the DELETE data
parse_str(file_get_contents("php://input"), $data); // Parse incoming DELETE data

// Check if the necessary parameters are provided
if (isset($user_id, $data['cart_id'])) {
    //$user_id = $data['user_id'];
    $cart_id = $data['cart_id'];

    // Validate input
    if (filter_var($user_id, FILTER_VALIDATE_INT) && filter_var($cart_id, FILTER_VALIDATE_INT)) {
        
        // Check if the cart item belongs to the user and is not checked out
        $query = "SELECT * FROM temp_cart WHERE id = ? AND user_id = ? AND is_checked_out = 0";
        
        if ($stmt = $conn->prepare($query)) {
            $stmt->bind_param("ii", $cart_id, $user_id);
            $stmt->execute();
            $result = $stmt->get_result();
            
            // If the cart item exists and belongs to the user
            if ($result->num_rows > 0) {
                // Delete the cart item
                $delete_query = "DELETE FROM temp_cart WHERE id = ? AND user_id = ? AND is_checked_out = 0";
                
                if ($delete_stmt = $conn->prepare($delete_query)) {
                    $delete_stmt->bind_param("ii", $cart_id, $user_id);
                    $delete_stmt->execute();
                    
                    // Check if the deletion was successful
                    if ($delete_stmt->affected_rows > 0) {
                        echo json_encode([
                            'status' => 'success',
                            'message' => 'Cart item removed successfully.',
                        ]);
                    } else {
                        echo json_encode([
                            'status' => 'error',
                            'message' => 'Failed to remove cart item.',
                        ]);
                    }
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Failed to prepare delete query.',
                    ]);
                }
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Cart item not found or already checked out.',
                ]);
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to prepare the select query.',
            ]);
        }
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Invalid input data.',
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Required fields (user_id, cart_id) are missing.',
    ]);
}

$conn->close();
?>
