<?php

header('Access-Control-Allow-Origin: http://localhost:5173');
// Allow all origins
header('Access-Control-Allow-Methods: GET, POST, OPTIONS'); // Allow specific HTTP methods
header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control'); // Allow specific headers
header('Content-Type: application/json');
require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;




$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    http_response_code(401); // Unauthorized
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);
//$secretKey = "e3ff5f077839c1331b1d893a728246685cb7dba9e3a77bffe7d52eaccf660988";

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null; // Extract user ID from token
    if (!$user_id) {
        http_response_code(400); // Unauthorized
        echo json_encode(['status' => 'error', 'message' => 'Invalid token: user ID not found']);
        exit;
    }
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}

// Check if user_id is provided in the request
if (isset($user_id)) {
    $user_id = $user_id;
    
    // Validate the user_id is an integer (you can improve validation based on your requirements)
    if (filter_var($user_id, FILTER_VALIDATE_INT)) {
        
        // Query to fetch cart items for the user, including additional details
        $query = "SELECT temp_cart.id AS cart_id, 
                         products.id AS product_id,
                         products.name AS Name,
                         products.sku, 
                         temp_cart.quantity, 
                         temp_cart.unit_price, 
                         products.image_url,
                         products.material,
                         products.coating,
                         products.width,
                         products.height,
                         products.slot_width,
                         products.making,
                         products.in_stock,
                         products.stock_quantity
                  FROM temp_cart 
                  INNER JOIN products ON temp_cart.product_id = products.id 
                  WHERE temp_cart.user_id = ? AND temp_cart.is_checked_out = 0"; // Excluding checked-out items
        
        // Prepare and execute the query
        if ($stmt = $conn->prepare($query)) {
            $stmt->bind_param("i", $user_id); // Bind user_id as an integer parameter
            $stmt->execute();
            $result = $stmt->get_result();
            
            // Check if cart has items
            if ($result->num_rows > 0) {
                $cart_items = [];
                
                // Fetch cart items
                while ($row = $result->fetch_assoc()) {
                    $cart_items[] = $row;
                }
                
                // Respond with success and the cart items
                echo json_encode([
                    'status' => 'success',
                    'cart_items' => $cart_items,
                ]);
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'No items found in the cart.',
                ]);
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to prepare the query.',
            ]);
        }
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Invalid user ID.',
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'User ID is required.',
    ]);
}

$conn->close();
?>
