<?php
header("Content-Type: application/json");
require_once '../dbconn.php'; // Include the database connection

$response = ["success" => false];

try {
    // Get date filters from GET parameters
    $start_date = isset($_GET['start_date']) ? $_GET['start_date'] : null;
    $end_date = isset($_GET['end_date']) ? $_GET['end_date'] : null;
    $page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
    $limit = isset($_GET['limit']) ? max(1, intval($_GET['limit'])) : 10;
    $offset = ($page - 1) * $limit;

    $query = "SELECT id, user_id, message, category, created_at FROM help_center_messages";
    $count_query = "SELECT COUNT(*) AS total FROM help_center_messages";
    $params = [];
    $types = "";
    $conditions = [];

    // Apply date filters if provided
    if ($start_date && $end_date) {
        $conditions[] = "DATE(created_at) BETWEEN ? AND ?";
        $params = [$start_date, $end_date];
        $types = "ss";
    } elseif ($start_date) {
        $conditions[] = "DATE(created_at) >= ?";
        $params = [$start_date];
        $types = "s";
    } elseif ($end_date) {
        $conditions[] = "DATE(created_at) <= ?";
        $params = [$end_date];
        $types = "s";
    }

    if (!empty($conditions)) {
        $query .= " WHERE " . implode(" AND ", $conditions);
        $count_query .= " WHERE " . implode(" AND ", $conditions);
    }

    // Get total count
    $stmt = $conn->prepare($count_query);
    if (!empty($params)) {
        $stmt->bind_param($types, ...$params);
    }
    $stmt->execute();
    $count_result = $stmt->get_result();
    $total_count = $count_result->fetch_assoc()['total'];
    $stmt->close();

    // Apply pagination
    $query .= " LIMIT ? OFFSET ?";
    $params[] = $limit;
    $params[] = $offset;
    $types .= "ii";

    $stmt = $conn->prepare($query);
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $result = $stmt->get_result();

    $messages = [];
    while ($row = $result->fetch_assoc()) {
        $messages[] = $row;
    }

    $response["success"] = true;
    $response["messages"] = $messages;
    $response["total_count"] = $total_count;
    $response["current_page"] = $page;
    $response["total_pages"] = ceil($total_count / $limit);

    $stmt->close();
} catch (Exception $e) {
    $response["message"] = "Error fetching messages: " . $e->getMessage();
}

echo json_encode($response);
?>
