<?php
function decodeToken($token) {
    $key = "your_secret_key"; // Use the same key as in the login API

    // Split the token into parts (header.payload.signature)
    $parts = explode('.', $token);
    if (count($parts) !== 2) {
        return null; // Invalid token format
    }

    // Decode the payload
    $payload = json_decode(base64_decode($parts[0]), true);
    if (!$payload) {
        return null; // Invalid payload
    }

    // Verify signature
    $expected_signature = hash_hmac('sha256', json_encode($payload), $key);
    if ($parts[1] !== $expected_signature) {
        return null; // Signature mismatch
    }

    // Check token expiry
    if ($payload['exp'] < time()) {
        return null; // Token expired
    }

    return $payload; // Return the decoded payload (user data)
}
?>
