<?php
header("Content-Type: application/json");
require '../dbconn.php'; // Database connection

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $code = isset($_POST['code']) ? trim($_POST['code']) : '';
    $order_details = isset($_POST['order_details']) ? json_decode($_POST['order_details'], true) : [];

    if ($code === '' || empty($order_details) || !isset($order_details['order_details']['sub_total'])) {
        echo json_encode(["success" => false, "message" => "Invalid input"]);
        exit;
    }
    
    $sub_total = floatval($order_details['order_details']['sub_total']);
    
    // Check if promo code exists and is active
    $stmt = $conn->prepare("SELECT id, type, discount_value, minimum_purchase, maximum_discount, usage_limit, times_used, is_active, valid_from, valid_until FROM promocodes WHERE code = ? AND is_active = 1");
    $stmt->bind_param("s", $code);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
        echo json_encode(["success" => false, "message" => "Invalid or expired promo code"]);
        exit;
    }
    
    $promo = $result->fetch_assoc();
    $current_date = date("Y-m-d H:i:s");
    
    // Validate date range
    if ($current_date < $promo['valid_from'] || $current_date > $promo['valid_until']) {
        echo json_encode(["success" => false, "message" => "Promo code is not valid at this time"]);
        exit;
    }
    
    // Check minimum purchase amount
    if ($sub_total < $promo['minimum_purchase']) {
        echo json_encode(["success" => false, "message" => "Cart total is below the minimum purchase requirement"]);
        exit;
    }
    
    // Check usage limit
    if ($promo['times_used'] >= $promo['usage_limit']) {
        echo json_encode(["success" => false, "message" => "Promo code usage limit reached"]);
        exit;
    }
    
    // Calculate discount amount
    $discount_amount = 0;
    if ($promo['type'] === 'PERCENTAGE') {
        $discount_amount = ($sub_total * $promo['discount_value']) / 100;
        if ($discount_amount > $promo['maximum_discount']) {
            $discount_amount = $promo['maximum_discount'];
        }
    } elseif ($promo['type'] === 'FIXED') {
        $discount_amount = min($promo['discount_value'], $promo['maximum_discount']);
    }
    
    $final_total = $sub_total - $discount_amount;
    
    echo json_encode([
        "success" => true,
        "data" => [
            "sub_total" => $sub_total,
            "discount_amount" => $discount_amount,
            "final_total" => $final_total
        ]
    ]);
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
}
?>
