<?php
header('Access-Control-Allow-Origin: http://localhost:5173');
// Allow all origins
header('Access-Control-Allow-Methods: GET, POST, OPTIONS'); // Allow specific HTTP methods
header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control'); // Allow specific headers
header('Content-Type: application/json');
require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;




$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    http_response_code(401); // Unauthorized
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);
//$secretKey = "e3ff5f077839c1331b1d893a728246685cb7dba9e3a77bffe7d52eaccf660988";

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null; // Extract user ID from token
    if (!$user_id) {
        http_response_code(400); // Unauthorized
        echo json_encode(['status' => 'error', 'message' => 'Invalid token: user ID not found']);
        exit;
    }
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

// Capture POST parameters
//$user_id = $_POST['user_id'] ?? null;
$first_name = $_POST['first_name'] ?? null;
$last_name = $_POST['last_name'] ?? null;
$phone_number = $_POST['phone_number'] ?? null;
$pincode = $_POST['pincode'] ?? null;
$flat_building = $_POST['flat_building'] ?? null;
$area_street = $_POST['area_street'] ?? null;
$landmark = $_POST['landmark'] ?? '';
$city = $_POST['city'] ?? null;
$state = $_POST['state'] ?? null;
$country = $_POST['country'] ?? null;

// Validate required fields
if (!$user_id || !$first_name || !$last_name || !$phone_number || !$pincode || !$flat_building || !$area_street || !$city || !$state || !$country) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
    exit;
}

// Insert query
$query = "INSERT INTO shipping_addresses (user_id, first_name, last_name, phone_number, pincode, flat_building, area_street, landmark, city, state, country) 
          VALUES ('$user_id', '$first_name', '$last_name', '$phone_number', '$pincode', '$flat_building', '$area_street', '$landmark', '$city', '$state', '$country')";

if ($conn->query($query) === TRUE) {
    echo json_encode(['status' => 'success', 'message' => 'Shipping address added successfully', 'id' => $conn->insert_id]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Error inserting shipping address: ' . $conn->error]);
}

$conn->close();
?>
