<?php
header("Content-Type: application/json");
require '../dbconn.php';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $username = $_POST["username"];
    $password = $_POST["password"];
    $role = $_POST["role"]; // Get role from request

    $stmt = $conn->prepare("SELECT password_hash, role FROM admin WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $stmt->store_result();
    
    if ($stmt->num_rows > 0) {
        $stmt->bind_result($hashed_password, $db_role);
        $stmt->fetch();

        if (password_verify($password, $hashed_password)) {
            if ($db_role === $role) { // Check if role matches
                echo json_encode(["success" => true, "message" => "Login successful", "role" => $db_role]);
            } else {
                echo json_encode(["success" => false, "message" => "Incorrect role"]);
            }
        } else {
            echo json_encode(["success" => false, "message" => "Invalid password"]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "User not found"]);
    }

    $stmt->close();
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
}

$conn->close();
?>
