<?php

require('../dbconn.php');

header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

$query = "SELECT quotes.id, users.name, quotes.quote_pdf, quotes.total_price, quotes.created_at 
          FROM quotes 
          INNER JOIN users ON quotes.user_id = users.id 
          ORDER BY quotes.created_at DESC";

$result = $conn->query($query);

if ($result->num_rows > 0) {
    $quotes = [];

    while ($row = $result->fetch_assoc()) {
        $row['quote_pdf'] = 'https://sandbox.boltkart.in/API/' . $row['quote_pdf'];
        $quotes[] = $row;
    }

    echo json_encode(['status' => 'success', 'quotes' => $quotes]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No quotes found.']);
}

$conn->close();
?>
