<?php


error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Content-Type: application/json");
require '../dbconn.php';
require_once "../../middlewares/verifyJWT.php";

// CHECK AUTH
// $auth = verifyJWT();
// if (!$auth["success"]) {
//     echo json_encode(["success" => false, "message" => "Unauthorized"]);
//     exit;
// }

// $user = $auth["data"];
// $user_role = $user["role"] ?? null;

// if ($user_role !== "admin") {
//     echo json_encode(["success" => false, "message" => "Only admin can delete categories"]);
//     exit;
// }

// ALLOW ONLY DELETE
if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    echo json_encode(["success" => false, "message" => "Invalid method. Use DELETE"]);
    exit;
}

// GET category_id
$category_id = $_GET["category_id"] ?? null;

if (!$category_id) {
    echo json_encode(["success" => false, "message" => "category_id is required"]);
    exit;
}

// CHECK CATEGORY EXISTS
$sql = "SELECT * FROM categories WHERE category_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $category_id);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows === 0) {
    echo json_encode(["success" => false, "message" => "Category not found"]);
    exit;
}

// SOFT DELETE → SET active = 0
$sql_del = "UPDATE categories SET active = 0 WHERE category_id = ?";
$stmt_del = $conn->prepare($sql_del);
$stmt_del->bind_param("i", $category_id);

if ($stmt_del->execute()) {
    echo json_encode([
        "success" => true,
        "message" => "Category deleted successfully",
        "category_id" => $category_id
    ]);
} else {
    echo json_encode([
        "success" => false,
        "message" => "Failed to deactivate category"
    ]);
}

exit;

?>
