<?php
header('Content-Type: application/json');
require '../dbconn.php'; // Ensure this file sets up $conn properly

$response = ["success" => false];

try {
    // Set default date range (last 30 days)
    $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : date('Y-m-d', strtotime('-30 days'));
    $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : date('Y-m-d');
    
    // Get total orders count
    $orderQuery = "SELECT COUNT(id) AS count FROM orders WHERE created_at BETWEEN ? AND ?";
    $stmt = $conn->prepare($orderQuery);
    $stmt->bind_param("ss", $startDate, $endDate);
    $stmt->execute();
    $orderResult = $stmt->get_result();
    $orders = $orderResult->fetch_assoc();

    // Get total revenue
    $revenueQuery = "SELECT SUM(total_amount) AS amount FROM orders WHERE created_at BETWEEN ? AND ?";
    $stmt = $conn->prepare($revenueQuery);
    $stmt->bind_param("ss", $startDate, $endDate);
    $stmt->execute();
    $revenueResult = $stmt->get_result();
    $revenue = $revenueResult->fetch_assoc();

    // Get active users count
    $usersQuery = "SELECT COUNT(id) AS count FROM users WHERE created_at BETWEEN ? AND ?";
    $stmt = $conn->prepare($usersQuery);
    $stmt->bind_param("ss", $startDate, $endDate);
    $stmt->execute();
    $usersResult = $stmt->get_result();
    $users = $usersResult->fetch_assoc();

    // Get low stock items count
    $stockQuery = "SELECT COUNT(id) AS count FROM products WHERE stock_quantity < 10 AND updated_at BETWEEN ? AND ?";
    $stmt = $conn->prepare($stockQuery);
    $stmt->bind_param("ss", $startDate, $endDate);
    $stmt->execute();
    $stockResult = $stmt->get_result();
    $stock = $stockResult->fetch_assoc();

    // Get average order value
    $aovQuery = "SELECT AVG(total_amount) AS avg_order_value 
                 FROM orders 
                 WHERE created_at BETWEEN ? AND ?";
    $stmt = $conn->prepare($aovQuery);
    $stmt->bind_param("ss", $startDate, $endDate);
    $stmt->execute();
    $aovResult = $stmt->get_result();
    $aov = $aovResult->fetch_assoc();

    // Initialize response data
    $response = [
        "success" => true,
        "total_orders" => [
            "count" => (int) $orders['count']
        ],
        "total_revenue" => [
            "amount" => (float) $revenue['amount']
        ],
        "active_users" => [
            "count" => (int) $users['count']
        ],
        "low_stock_items" => [
            "count" => (int) $stock['count']
        ],
        "average_order_value" => [
            "amount" => (float) $aov['avg_order_value']
        ]
    ];

} catch (Exception $e) {
    $response = [
        "success" => false,
        "error" => $e->getMessage()
    ];
}

echo json_encode($response);
?>
