<?php
header('Content-Type: application/json');
require '../dbconn.php'; // Ensure this file sets up $conn properly

$response = ["success" => false];

try {
    // Get total orders count and growth percentage
    $orderQuery = "SELECT COUNT(id) AS count, 
                          (COALESCE((COUNT(id) - LAG(COUNT(id)) OVER (ORDER BY created_at DESC)) / NULLIF(LAG(COUNT(id)) OVER (ORDER BY created_at DESC), 0) * 100, 0)) AS growth_percentage
                   FROM orders";
    $orderResult = $conn->query($orderQuery);
    $orders = $orderResult->fetch_assoc();

    // Get total revenue and growth percentage
    $revenueQuery = "SELECT SUM(total_amount) AS amount, 
                            (COALESCE((SUM(total_amount) - LAG(SUM(total_amount)) OVER (ORDER BY created_at DESC)) / NULLIF(LAG(SUM(total_amount)) OVER (ORDER BY created_at DESC), 0) * 100, 0)) AS growth_percentage
                     FROM orders";
    $revenueResult = $conn->query($revenueQuery);
    $revenue = $revenueResult->fetch_assoc();

    // Get active users count and growth percentage
    $usersQuery = "SELECT COUNT(id) AS count, 
                          (COALESCE((COUNT(id) - LAG(COUNT(id)) OVER (ORDER BY created_at DESC)) / NULLIF(LAG(COUNT(id)) OVER (ORDER BY created_at DESC), 0) * 100, 0)) AS growth_percentage
                   FROM users WHERE is_verified = 1";
    $usersResult = $conn->query($usersQuery);
    $users = $usersResult->fetch_assoc();

    // Get low stock items count and growth percentage
    $stockQuery = "SELECT COUNT(id) AS count, 
                          (COALESCE((COUNT(id) - LAG(COUNT(id)) OVER (ORDER BY updated_at DESC)) / NULLIF(LAG(COUNT(id)) OVER (ORDER BY updated_at DESC), 0) * 100, 0)) AS growth_percentage
                   FROM products WHERE stock_quantity < 10";
    $stockResult = $conn->query($stockQuery);
    $stock = $stockResult->fetch_assoc();

    $response = [
        "success" => true,
        "total_orders" => [
            "count" => (int) $orders['count'],
            "growth_percentage" => (float) $orders['growth_percentage']
        ],
        "total_revenue" => [
            "amount" => (float) $revenue['amount'],
            "growth_percentage" => (float) $revenue['growth_percentage']
        ],
        "active_users" => [
            "count" => (int) $users['count'],
            "growth_percentage" => (float) $users['growth_percentage']
        ],
        "low_stock_items" => [
            "count" => (int) $stock['count'],
            "growth_percentage" => (float) $stock['growth_percentage']
        ]
    ];
} catch (Exception $e) {
    $response["error"] = $e->getMessage();
}

echo json_encode($response);
?>
