<?php
header('Content-Type: application/json');
require '../dbconn.php'; // Ensure this file sets up $conn properly

$response = ["success" => false];

// Get Orders and Customers Trend API
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['start_date']) && isset($_GET['end_date'])) {
    $start_date = $_GET['start_date'];
    $end_date = $_GET['end_date'];

    try {
        $trendQuery = "SELECT DATE_FORMAT(created_at, '%b') AS month, COUNT(id) AS orders, COUNT(DISTINCT user_id) AS customers 
                        FROM orders 
                        WHERE created_at BETWEEN ? AND ?
                        GROUP BY month
                        ORDER BY MIN(created_at)";
        
        $stmt = $conn->prepare($trendQuery);
        $stmt->bind_param("ss", $start_date, $end_date);
        $stmt->execute();
        $result = $stmt->get_result();
        
        $trend = [];
        while ($row = $result->fetch_assoc()) {
            $trend[] = [
                "month" => $row['month'],
                "orders" => (int) $row['orders'],
                "customers" => (int) $row['customers']
            ];
        }
        
        $response = [
            "success" => true,
            "trend" => $trend
        ];
    } catch (Exception $e) {
        $response = [
            "success" => false,
            "error" => $e->getMessage()
        ];
    }

    echo json_encode($response);
}
?>
