<?php
include '../dbconn.php';
header('Content-Type: application/json');

// Get pagination parameters
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 10;

// Get filter parameters
$status = isset($_GET['status']) ? $_GET['status'] : '';
$fromDate = isset($_GET['fromDate']) ? $_GET['fromDate'] : '';
$toDate = isset($_GET['toDate']) ? $_GET['toDate'] : '';
$search = isset($_GET['search']) ? $_GET['search'] : '';
$paymentMethod = isset($_GET['payment_method']) ? $_GET['payment_method'] : ''; // Added payment method filter

$offset = ($page - 1) * $limit;

// Build WHERE clauses
$whereClauses = [];
$params = [];

if (!empty($status)) {
    $whereClauses[] = "order_status = ?";
    $params[] = $status;
}

if (!empty($fromDate)) {
    $whereClauses[] = "created_at >= ?";
    $params[] = $fromDate;
}

if (!empty($toDate)) {
    $whereClauses[] = "created_at <= ?";
    $params[] = $toDate;
}

if (!empty($search)) {
    $whereClauses[] = "(users.name LIKE ? OR users.email LIKE ? OR orders.id LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

// Add payment method filter
if (!empty($paymentMethod)) {
    $whereClauses[] = "payment_method = ?";
    $params[] = $paymentMethod;
}

$whereSQL = count($whereClauses) > 0 ? 'WHERE ' . implode(' AND ', $whereClauses) : '';

// Get total count of records
$countSql = "SELECT COUNT(*) as total FROM orders JOIN users ON orders.user_id = users.id $whereSQL";
$countStmt = $conn->prepare($countSql);
if (!empty($params)) {
    $countStmt->execute($params);
} else {
    $countStmt->execute();
}
$countResult = $countStmt->get_result();
$totalCount = $countResult->fetch_assoc()['total'];

// Get count of each order status
$statusCounts = [
    'new' => 0,
    'processing' => 0,
    'delivered' => 0,
    'returned' => 0
];

// SQL to get status counts
$statusSql = "SELECT order_status, COUNT(*) as count 
              FROM orders
              WHERE order_status IN ('confirmed', 'shipped', 'delivered', 'cancelled')
              GROUP BY order_status";
$statusStmt = $conn->prepare($statusSql);
$statusStmt->execute();
$statusResult = $statusStmt->get_result();

while ($row = $statusResult->fetch_assoc()) {
    $statusCounts[$row['order_status']] = (int)$row['count'];
}

// Fetch paginated records
$sql = "SELECT orders.*, users.name AS customer_name, users.email AS customer_email
        FROM orders
        JOIN users ON orders.user_id = users.id
        $whereSQL
        ORDER BY created_at DESC
        LIMIT ? OFFSET ?";
$params[] = $limit;
$params[] = $offset;
$stmt = $conn->prepare($sql);
$stmt->execute($params);
$result = $stmt->get_result();

$orders = [];
while ($row = $result->fetch_assoc()) {
    $orders[] = $row;
}

$totalPages = ceil($totalCount / $limit);

// Response with added status counts
echo json_encode([
    "success" => true,
    "data" => $orders,
    "page" => $page,
    "limit" => $limit,
    "total_records" => $totalCount,
    "total_pages" => $totalPages,
    "order_counts" => [
        "confirmed" => $statusCounts['confirmed'],
        "shipped" => $statusCounts['shipped'],
        "delivered" => $statusCounts['delivered'],
        "cancelled" => $statusCounts['cancelled']
    ]
]);
?>