<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json");
require_once '../dbconn.php';

define("HTTP_METHOD", $_SERVER['REQUEST_METHOD']);

if (HTTP_METHOD != 'POST') {
    echo json_encode(["success" => false, "error" => "Invalid request method"]);
    exit;
}

if (!isset($_POST['product_variant_id'])) {
    echo json_encode(["success" => false, "error" => "Missing variant id"]);
    exit;
}

$id = intval($_POST['product_variant_id']);
// echo $id;
// Check if variant exists
$check = $conn->prepare("SELECT product_variant_id FROM product_variants WHERE product_variant_id = ?");
$check->bind_param("i", $id);
$check->execute();
$result = $check->get_result();

if ($result->num_rows === 0) {
    echo json_encode(["success" => false, "error" => "Variant not found"]);
    exit;
}

// Soft delete → set in_stock = 0
$stmt = $conn->prepare("
    UPDATE product_variants 
    SET active = 0, updated_at = NOW() 
    WHERE product_variant_id = ?
");
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    echo json_encode([
        "success" => true,
        "message" => "Variant deactivated successfully",
        "updated_id" => $id
    ]);
} else {
    echo json_encode(["success" => false, "error" => $stmt->error]);
}

$stmt->close();
$conn->close();
?>
