<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json");
require_once '../dbconn.php';

define("HTTP_METHOD", $_SERVER['REQUEST_METHOD']);

if (HTTP_METHOD !== 'GET') {
    echo json_encode(["success" => false, "error" => "Invalid request method"]);
    exit;
}

$id = isset($_GET['id']) ? intval($_GET['id']) : null;
$product_ref_id = isset($_GET['product_ref_id']) ? intval($_GET['product_ref_id']) : null;
// $product_ref_id = 72;
// echo "72";
// $query = "SELECT product_variant_id, product_ref_id, sku, price, stock_quantity, image_url, specifications,
//                  is_default, in_stock, name, description, created_at, updated_at
//           FROM product_variants";

// $params = [];
// $types  = "";

// if ($id) {
//     $query .= " WHERE id = ? AND active = 1 ";
//     $params[] = $id;
//     $types .= "i";

// } elseif ($product_ref_id) {
//     $query .= " WHERE product_ref_id = ? AND active = 1 ";
//     $params[] = $product_ref_id;
//     $types .= "i";
// }

// $stmt = $conn->prepare($query);

$query = "SELECT 
                pv.product_variant_id, 
                pv.product_ref_id, 
                pv.sku, 
                pv.price, 
                pv.stock_quantity, 
                pv.cut_and_clean_price,
                
                -- If pv.image_url is null → return product image
                CASE 
                    WHEN pv.image_url IS NULL OR pv.image_url = '' 
                    THEN p.image_url 
                    ELSE pv.image_url 
                END AS image_url,
                
                pv.specifications,
                pv.is_default, 
                pv.in_stock, 
                pv.name, 
                pv.description, 
                pv.created_at, 
                pv.updated_at
          FROM product_variants pv
          LEFT JOIN products p 
                ON p.product_id = pv.product_ref_id";

$params = [];
$types  = "";

// Filter by variant ID
if ($id) {
    $query .= " WHERE pv.id = ? AND pv.active = 1";
    $params[] = $id;
    $types .= "i";

} elseif ($product_ref_id) {
    // Filter by product reference ID
    $query .= " WHERE pv.product_ref_id = ? AND pv.active = 1";
    $params[] = $product_ref_id;
    $types .= "i";
}

$stmt = $conn->prepare($query);


if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();

$variants = [];

while ($row = $result->fetch_assoc()) {
    
    $row['specifications'] = json_decode($row['specifications'], true);
    $variants[] = $row;
}


echo json_encode([
    "success" => true,
    "data" => $variants
]);

$stmt->close();
$conn->close();
?>
