<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Content-Type: application/json");

require '../dbconn.php';
require_once "../../middlewares/verifyJWT.php";

// CHECK AUTH
// $auth = verifyJWT();
// if (!$auth["success"]) {
//     echo json_encode(["success" => false, "message" => "Unauthorized"]);
//     exit;
// }

// $user = $auth["data"];
// $user_role = $user["role"] ?? null;

// if ($user_role !== "admin") {
//     echo json_encode(["success" => false, "message" => "Only admin can add products"]);
//     exit;
// }

// ALLOW ONLY POST
if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    echo json_encode(["success" => false, "message" => "Invalid request method. Use POST"]);
    exit;
}

// GET FORM-DATA
$name = $_POST["name"] ?? null;
$description = $_POST["description"] ?? null;
$category_id = $_POST["category_id"] ?? null;
$base_price = $_POST["base_price"] ?? null;
$scientific_name = $_POST["scientific_name"] ?? null;

// VALIDATION

if (!$name || !$description || !$category_id || !$scientific_name || !$base_price) {
    echo json_encode(["success" => false, "message" => "All fields including category_id are required"]);
    exit;
}

// CHECK IF CATEGORY EXISTS
$sql_cat = "SELECT category_id FROM categories WHERE category_id = ?";
$stmt_cat = $conn->prepare($sql_cat);
$stmt_cat->bind_param("i", $category_id);
$stmt_cat->execute();
$res_cat = $stmt_cat->get_result();

if ($res_cat->num_rows === 0) {
    echo json_encode(["success" => false, "message" => "Category not found"]);
    exit;
}

// HANDLE IMAGE UPLOAD
$image_path = null;
if (isset($_FILES["image"]) && $_FILES["image"]["error"] === 0) {
    $img_name = time() . "_" . basename($_FILES["image"]["name"]);
    $target_dir = "../../Admin/products/uploads/";
    $target_file = $target_dir . $img_name;

    if (!file_exists($target_dir)) mkdir($target_dir, 0777, true);

    if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
        $image_path = "Admin/products/uploads/" . $img_name;
    } else {
        echo json_encode(["success" => false, "message" => "Image upload failed"]);
        exit;
    }
} else {
    echo json_encode(["success" => false, "message" => "Product image is required"]);
    exit;
}

// INSERT PRODUCT INTO DATABASE
$sql = "INSERT INTO products (name, description, image_url, category_ref_id, scientific_name, base_price) 
        VALUES (?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("sssisd", $name, $description, $image_path, $category_id, $scientific_name, $base_price);

if ($stmt->execute()) {
    echo json_encode([
        "success" => true,
        "message" => "Product added successfully",
        "product_id" => $stmt->insert_id,
        "image" => $image_path,
        "category_id" => $category_id
    ]);
    exit;
} else {
    echo json_encode(["success" => false, "message" => "Database insert failed"]);
    exit;
}
?>
