<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Content-Type: application/json");
require '../dbconn.php';
require_once "../../middlewares/verifyJWT.php";

// CHECK AUTH
// $auth = verifyJWT();
// if (!$auth["success"]) {
//     echo json_encode(["success" => false, "message" => "Unauthorized"]);
//     exit;
// }

// $user = $auth["data"];
// $user_role = $user["role"] ?? null;

// if ($user_role !== "admin") {
//     echo json_encode(["success" => false, "message" => "Only admin can delete products"]);
//     exit;
// }

// ALLOW ONLY DELETE
if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    echo json_encode(["success" => false, "message" => "Invalid request method. Use DELETE"]);
    exit;
}

// GET PRODUCT ID FROM URL PARAMS
$product_id = isset($_GET["product_id"]) ? (int)$_GET["product_id"] : null;

if (!$product_id) {
    echo json_encode(["success" => false, "message" => "Product ID is required in URL parameters"]);
    exit;
}

// CHECK IF PRODUCT EXISTS
$sql_check = "SELECT product_id FROM products WHERE product_id = ?";
$stmt_check = $conn->prepare($sql_check);
$stmt_check->bind_param("i", $product_id);
$stmt_check->execute();
$result_check = $stmt_check->get_result();

if ($result_check->num_rows === 0) {
    echo json_encode(["success" => false, "message" => "Product not found"]);
    exit;
}

// SOFT DELETE: SET active = 0
$sql_delete = "UPDATE products SET active = 0 WHERE product_id = ?";
$stmt_delete = $conn->prepare($sql_delete);
$stmt_delete->bind_param("i", $product_id);

if ($stmt_delete->execute()) {
    echo json_encode([
        "success" => true,
        "message" => "Product deleted successfully",
        "product_id" => $product_id
    ]);
} else {
    echo json_encode(["success" => false, "message" => "product deleted failed"]);
}

$stmt_delete->close();
$stmt_check->close();
$conn->close();
?>
