<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Content-Type: application/json");

require '../dbconn.php';
require_once "../../middlewares/verifyJWT.php";

// AUTH CHECK
// $auth = verifyJWT();
// if (!$auth["success"]) {
//     echo json_encode(["success" => false, "message" => "Unauthorized"]);
//     exit;
// }

// $user = $auth["data"];
// if ($user["role"] !== "admin") {
//     echo json_encode(["success" => false, "message" => "Only admin can access"]);
//     exit;
// }

// GET product_id from PARAMS
$product_id = $_GET["product_id"] ?? null;

if (!$product_id) {
    echo json_encode(["success" => false, "message" => "product_id is required"]);
    exit;
}

// FETCH MAIN PRODUCT DETAIL
$sql_product = "SELECT * FROM products WHERE product_id = ?";
$stmt = $conn->prepare($sql_product);
$stmt->bind_param("i", $product_id);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows === 0) {
    echo json_encode(["success" => false, "message" => "Product not found"]);
    exit;
}

$product = $res->fetch_assoc();

// FETCH PRODUCT VARIANTS
$sql_var = "SELECT * FROM product_variants WHERE product_ref_id = ? AND active = 1";
$stmt_var = $conn->prepare($sql_var);
$stmt_var->bind_param("i", $product_id);
$stmt_var->execute();
$res_var = $stmt_var->get_result();

$variants = [];
while ($row = $res_var->fetch_assoc()) {
     $row['specifications'] = json_decode($row['specifications'], true);
    $variants[] = $row;
}
$product['variants'] = $variants;

// FINAL RESPONSE
echo json_encode([
    "success" => true,
    "message" => "Product details fetched successfully",
    "product" => $product
]);
exit;
?>
