<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json");
require_once '../dbconn.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["success" => false, "error" => "Invalid request method"]);
    exit;
}

// Validate required fields
$required_fields = ['code', 'type', 'discount_value', 'valid_from', 'valid_until'];
foreach ($required_fields as $field) {
    if (!isset($_POST[$field]) || empty(trim($_POST[$field]))) {
        echo json_encode(["success" => false, "error" => "Missing required field: $field"]);
        exit;
    }
}

// Get input values from form data
$code = trim($_POST['code']);
$type = $_POST['type'];
$discount_value = floatval($_POST['discount_value']);
$minimum_purchase = isset($_POST['minimum_purchase']) ? floatval($_POST['minimum_purchase']) : null;
$maximum_discount = isset($_POST['maximum_discount']) ? floatval($_POST['maximum_discount']) : null;
$usage_limit = isset($_POST['usage_limit']) ? intval($_POST['usage_limit']) : null;
$valid_from = $_POST['valid_from'];
$valid_until = $_POST['valid_until'];
$is_active = isset($_POST['is_active']) ? intval($_POST['is_active']) : 1; // Default: true

// Validate type and required fields based on type
if (!in_array($type, ['percentage', 'fixed'])) {
    echo json_encode(["success" => false, "error" => "Invalid promo type. Allowed: percentage, fixed"]);
    exit;
}
if ($type === 'percentage' && $maximum_discount === null) {
    echo json_encode(["success" => false, "error" => "maximum_discount is required for percentage type"]);
    exit;
}

// Check if the promo code already exists
$stmt = $conn->prepare("SELECT id FROM promocodes WHERE code = ?");
$stmt->bind_param("s", $code);
$stmt->execute();
$stmt->store_result();
if ($stmt->num_rows > 0) {
    echo json_encode(["success" => false, "error" => "Promo code already exists"]);
    exit;
}
$stmt->close();

// Insert promo code into the database
$query = "INSERT INTO promocodes 
            (code, type, discount_value, minimum_purchase, maximum_discount, usage_limit, times_used, is_active, valid_from, valid_until, created_at, updated_at) 
          VALUES (?, ?, ?, ?, ?, ?, 0, ?, ?, ?, NOW(), NOW())";

$stmt = $conn->prepare($query);
$stmt->bind_param("ssdiddiis", $code, $type, $discount_value, $minimum_purchase, $maximum_discount, $usage_limit, $is_active, $valid_from, $valid_until);

if ($stmt->execute()) {
    $promo_id = $stmt->insert_id;

    // Fetch the inserted promo code details
    $response_query = "SELECT * FROM promocodes WHERE id = ?";
    $resp_stmt = $conn->prepare($response_query);
    $resp_stmt->bind_param("i", $promo_id);
    $resp_stmt->execute();
    $result = $resp_stmt->get_result();
    $promo = $result->fetch_assoc();
    
    // Send promo code notification to all users
    $users_query = "SELECT id FROM users";
    $users_result = $conn->query($users_query);

    if ($users_result->num_rows > 0) {
        $insert_notifications = $conn->prepare("INSERT INTO notifications (user_id, type, title, message, deep_link, is_read, created_at) VALUES (?, ?, ?, ?, ?, 0, NOW())");

        while ($user = $users_result->fetch_assoc()) {
            $user_id = $user['id'];
            $title = "New Promo Code Available!";
            $message = "Use code '$code' to get a discount of $discount_value " . ($type === 'percentage' ? "%" : " currency units") . ". Valid from $valid_from to $valid_until.";
            $deep_link = "/promocode/$code"; // Adjust as per frontend implementation

            $insert_notifications->bind_param("issss", $user_id, $type, $title, $message, $deep_link);
            $insert_notifications->execute();
        }
        $insert_notifications->close();
    }

    // Return success response
    echo json_encode(["success" => true, "status" => "success", "message" => "Promo code created and notifications sent!", "data" => $promo]);
} else {
    echo json_encode(["success" => false, "error" => "Failed to create promo code"]);
}

$stmt->close();
$conn->close();
?>
