<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

require '../dbconn.php';

// Allow CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $code = $_POST['code'] ?? '';
    $type = $_POST['type'] ?? '';
    $discount_value = $_POST['discount_value'] ?? 0;
    $minimum_purchase = $_POST['minimum_purchase'] ?? 0;
    $maximum_discount = $_POST['maximum_discount'] ?? 0;
    $usage_limit = $_POST['usage_limit'] ?? 0;
    $valid_from = $_POST['valid_from'] ?? '';
    $valid_until = $_POST['valid_until'] ?? '';

    if (empty($code) || empty($type) || empty($valid_from) || empty($valid_until)) {
        echo json_encode(["success" => false, "message" => "Missing required fields"]);
        exit;
    }

    // Check if the promo code already exists
    $check_stmt = $conn->prepare("SELECT id FROM promocodes WHERE code = ?");
    $check_stmt->bind_param("s", $code);
    $check_stmt->execute();
    $check_stmt->store_result();

    if ($check_stmt->num_rows > 0) {
        echo json_encode(["success" => false, "message" => "Promo code already exists"]);
        $check_stmt->close();
        $conn->close();
        exit;
    }
    $check_stmt->close();

    // Insert new promo code
    $stmt = $conn->prepare("INSERT INTO promocodes (code, type, discount_value, minimum_purchase, maximum_discount, usage_limit, valid_from, valid_until) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssddddss", $code, $type, $discount_value, $minimum_purchase, $maximum_discount, $usage_limit, $valid_from, $valid_until);
    
    if ($stmt->execute()) {
        echo json_encode(["success" => true, "message" => "Promo code created successfully"]);
    } else {
        echo json_encode(["success" => false, "message" => "Failed to create promo code"]);
    }

    $stmt->close();
    $conn->close();
}
?>
