<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET");

require_once '../dbconn.php'; // Include the database connection file

$response = ["success" => false];

if (!$conn) {
    $response["error"] = "Database connection failed";
    echo json_encode($response);
    exit;
}

// Get pagination parameters
$limit = isset($_GET["limit"]) ? intval($_GET["limit"]) : 10; // Default limit: 10
$page = isset($_GET["page"]) ? intval($_GET["page"]) : 1; // Default page: 1
$offset = ($page - 1) * $limit;

// Get search and filter parameters
$search = isset($_GET["search"]) ? trim($_GET["search"]) : "";
$status_filter = isset($_GET["status"]) ? trim($_GET["status"]) : "";
$start_date = isset($_GET["start_date"]) ? trim($_GET["start_date"]) : "";
$end_date = isset($_GET["end_date"]) ? trim($_GET["end_date"]) : "";

// Base query
$where_clauses = [];

// Search condition
if (!empty($search)) {
    $search = $conn->real_escape_string($search);
    $where_clauses[] = "(users.name LIKE '%$search%' OR users.email LIKE '%$search%' OR users.mobile LIKE '%$search%')";
}

// Filter by status
if ($status_filter === "Active" || $status_filter === "Blocked") {
    $status_condition = ($status_filter === "Active") ? "1" : "0";
    $where_clauses[] = "users.is_verified = $status_condition";
}

// Filter by joined date range
if (!empty($start_date) && !empty($end_date)) {
    $start_date = $conn->real_escape_string($start_date);
    $end_date = $conn->real_escape_string($end_date);
    $where_clauses[] = "(users.created_at BETWEEN '$start_date' AND '$end_date')";
}

// Build final WHERE clause
$where_sql = !empty($where_clauses) ? "WHERE " . implode(" AND ", $where_clauses) : "";

// Get total user count (with filters)
$count_query = "SELECT COUNT(*) AS total_users FROM users $where_sql";
$count_result = $conn->query($count_query);
$total_users = ($count_result && $row = $count_result->fetch_assoc()) ? intval($row["total_users"]) : 0;

// Get paginated user data with filters
$sql = "SELECT 
            users.id, 
            users.name, 
            users.email, 
            users.mobile, 
            users.created_at AS joined_date, 
            shipping_addresses.city, 
            shipping_addresses.state, 
            shipping_addresses.country, 
            (SELECT COUNT(*) FROM orders WHERE orders.user_id = users.id) AS order_count,
            (SELECT COALESCE(SUM(total_amount), 0) FROM orders WHERE orders.user_id = users.id) AS total_spent,
            CASE 
                WHEN users.is_verified = 1 THEN 'Active' 
                ELSE 'Blocked' 
            END AS status
        FROM users
        LEFT JOIN shipping_addresses ON users.id = shipping_addresses.user_id
        $where_sql
        LIMIT $limit OFFSET $offset";

$result = $conn->query($sql);

$users = [];
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $users[] = [
            "id" => $row["id"],
            "name" => $row["name"],
            "email" => $row["email"],
            "phone" => $row["mobile"],
            "location" => $row["city"] . ", " . $row["state"] . ", " . $row["country"],
            "joined_date" => date("F Y", strtotime($row["joined_date"])),
            "orders" => intval($row["order_count"]),
            "total_spent" => "$" . number_format($row["total_spent"], 2),
            "status" => $row["status"]
        ];
    }
    $response["success"] = true;
    $response["users"] = $users;
    $response["pagination"] = [
        "current_page" => $page,
        "limit" => $limit,
        "total_users" => $total_users,
        "total_pages" => ceil($total_users / $limit)
    ];
} else {
    $response["message"] = "No users found";
}

echo json_encode($response);
$conn->close();
?>
