<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;



// Allow CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

// Set response type
header('Content-Type: application/json');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}



$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);
//$secretKey = "e3ff5f077839c1331b1d893a728246685cb7dba9e3a77bffe7d52eaccf660988";

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null; // Extract user ID from token
    if (!$user_id) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid token: user ID not found']);
        exit;
    }
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}

// Prepare an array to hold the fields to update
$fields_to_update = [];

// Check for each optional field in the POST data and add it to the update array
if (isset($_POST['name'])) {
    $fields_to_update['name'] = $conn->real_escape_string($_POST['name']);
}
if (isset($_POST['email'])) {
    $fields_to_update['email'] = $conn->real_escape_string($_POST['email']);
}
if (isset($_POST['mobile'])) {
    $fields_to_update['mobile'] = $conn->real_escape_string($_POST['mobile']);
}
if (isset($_POST['password_hash'])) {
    $fields_to_update['password_hash'] = $conn->real_escape_string($_POST['password_hash']);
}
if (isset($_POST['is_verified'])) {
    $fields_to_update['is_verified'] = $conn->real_escape_string($_POST['is_verified']);
}

// If no fields are provided, return an error
if (empty($fields_to_update)) {
    echo json_encode(['status' => 'error', 'message' => 'No fields provided to update']);
    exit;
}

// Build the SQL query dynamically
$update_query = "UPDATE users SET ";
$update_parts = [];
foreach ($fields_to_update as $field => $value) {
    $update_parts[] = "$field = '$value'";
}
$update_query .= implode(', ', $update_parts);
$update_query .= " WHERE id = '$user_id'";

// Execute the update query
if ($conn->query($update_query) === TRUE) {
    // Fetch the updated user data
    $fetch_user_query = "SELECT name, email, mobile FROM users WHERE id = '$user_id'";
    $result = $conn->query($fetch_user_query);

    if ($result && $result->num_rows > 0) {
        $updated_user = $result->fetch_assoc();
        echo json_encode([
            'status' => 'success',
            'message' => 'Profile updated successfully',
            'data' => $updated_user
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Profile updated, but unable to fetch updated details'
        ]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Error updating profile: ' . $conn->error]);
}

// Close the connection
$conn->close();
?>