<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require('../dbconn.php'); // Include DB connection

// Set headers
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['banner_id']) && filter_var($_POST['banner_id'], FILTER_VALIDATE_INT)) {
        $banner_id = $_POST['banner_id'];

        // Fetch the image path from the database
        $query = "SELECT image_path FROM banners WHERE id = ?";
        if ($stmt = $conn->prepare($query)) {
            $stmt->bind_param("i", $banner_id);
            $stmt->execute();
            $stmt->bind_result($imagePath);
            $stmt->fetch();
            $stmt->close();

            if ($imagePath) {
                // Remove the file from the server
                $fileToDelete = "../" . $imagePath; // Adjust based on stored path
                if (file_exists($fileToDelete)) {
                    unlink($fileToDelete);
                }

                // Delete the record from the database
                $deleteQuery = "DELETE FROM banners WHERE id = ?";
                if ($stmt = $conn->prepare($deleteQuery)) {
                    $stmt->bind_param("i", $banner_id);
                    if ($stmt->execute()) {
                        echo json_encode(["status" => "success", "message" => "Banner deleted successfully!"]);
                    } else {
                        echo json_encode(["status" => "error", "message" => "Failed to delete banner from DB"]);
                    }
                    $stmt->close();
                }
            } else {
                echo json_encode(["status" => "error", "message" => "Banner not found!"]);
            }
        } else {
            echo json_encode(["status" => "error", "message" => "Database query failed"]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "Invalid banner ID"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
}

$conn->close();
?>
