<?php
header("Content-Type: application/json");

require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

/* ================= JWT AUTH ================= */

$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null;

    if (!$user_id) {
        http_response_code(401);
        echo json_encode(['status' => 'error', 'message' => 'Invalid token']);
        exit;
    }
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Token error']);
    exit;
}

/* ================= POST VALIDATION ================= */

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
    exit;
}

$cart_id = $_POST['cart_id'] ?? null;

if (!$cart_id || !filter_var($cart_id, FILTER_VALIDATE_INT)) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid cart_id']);
    exit;
}

/* ================= DELETE CART ITEM ================= */

$checkSql = "
  SELECT id 
  FROM temp_cart 
  WHERE id = ? 
  AND user_id = ? 
  AND is_checked_out = 0
";

$stmt = $conn->prepare($checkSql);
$stmt->bind_param("ii", $cart_id, $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Cart item not found or already checked out'
    ]);
    exit;
}

$deleteSql = "
  DELETE FROM temp_cart 
  WHERE id = ? 
  AND user_id = ? 
  AND is_checked_out = 0
";

$delStmt = $conn->prepare($deleteSql);
$delStmt->bind_param("ii", $cart_id, $user_id);
$delStmt->execute();

if ($delStmt->affected_rows > 0) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Cart item removed successfully'
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to remove cart item'
    ]);
}

$conn->close();
