<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require('../dbconn.php'); // Database connection

// Set response headers
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control');
header('Content-Type: application/json');

// Check for user_id parameter
if (!isset($_GET['user_id']) || empty($_GET['user_id'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Missing user_id parameter.'
    ]);
    exit;
}

$userId = intval($_GET['user_id']); // Sanitize input

// Query to fetch latest shipping_id and active cart items
$query = "
    SELECT 
        sa.id AS shipping_id,
        tc.product_id,
        tc.quantity
    FROM 
        shipping_addresses sa
    JOIN 
        temp_cart tc ON sa.user_id = tc.user_id
    WHERE 
        sa.user_id = $userId
        AND sa.id = (
            SELECT id
            FROM shipping_addresses
            WHERE user_id = $userId
            ORDER BY updated_at DESC
            LIMIT 1
        )
        AND tc.is_checked_out = false
";

$result = $conn->query($query);

$shippingId = null;
$items = [];

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        if ($shippingId === null) {
            $shippingId = $row['shipping_id'];
        }
        $items[] = [
            'product_id' => (int)$row['product_id'],
            'quantity' => (int)$row['quantity']
        ];
    }

    echo json_encode([
        'status' => 'success',
        'order_details' => [
            'shipping_id' => $shippingId,
            'items' => $items
        ]
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'No active order details found for the user.'
    ]);
}

$conn->close();
?>
