<?php
header('Content-Type: application/json');
require_once '../dbconn.php';

$response = [];

$sql = "SELECT pi.id, pi.order_id, pi.name, pi.mobile, pi.email, pi.status, 
               SUM(pi.total_amount) AS total_amount, 
               SUM(pi.paid_amount) AS paid_amount, 
               MIN(pi.due_amount) AS due_amount, 
               MAX(pi.created_at) AS latest_due_date 
        FROM proforma_invoice pi group by pi.order_id;";


$result = mysqli_query($conn, $sql);

if ($result) {
    $data = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $data[] = $row;
    }
    $response['status'] = true;
    $response['data'] = $data;
} else {
    $response['status'] = false;
    $response['message'] = 'Error fetching data: ' . mysqli_error($conn);
}

echo json_encode($response);
?>
