<?php
header("Content-Type: application/json");
require '../dbconn.php'; // Include database connection

$response = ["success" => false];

if ($_SERVER["REQUEST_METHOD"] === "GET") {
    $order_id = isset($_GET['order_id']) ? intval($_GET['order_id']) : 0;
    
    if ($order_id > 0) {
        $stmt = $conn->prepare("SELECT id, created_at, paid_amount FROM proforma_invoice WHERE order_id = ? ORDER BY created_at DESC");
        $stmt->bind_param("i", $order_id);
    } else {
        $stmt = $conn->prepare("SELECT id, created_at, paid_amount FROM proforma_invoice ORDER BY created_at DESC");
    }
    
    $stmt->execute();
    $result = $stmt->get_result();
    
    $installments = [];
    while ($row = $result->fetch_assoc()) {
        $installments[] = $row;
    }
    
    $response["success"] = true;
    $response["installments"] = $installments;
    
    $stmt->close();
}

echo json_encode($response);
?>
