<?php
// Set response headers
header('Access-Control-Allow-Origin: http://localhost:5173');
// Allow all origins
header('Access-Control-Allow-Methods: GET, POST, OPTIONS'); // Allow specific HTTP methods
header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control'); // Allow specific headers
header('Content-Type: application/json');
require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;







$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);
//$secretKey = "e3ff5f077839c1331b1d893a728246685cb7dba9e3a77bffe7d52eaccf660988";

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null; // Extract user ID from token
    if (!$user_id) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid token: user ID not found']);
        exit;
    }
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}

// Include the database connection

// Get the PUT data
parse_str(file_get_contents("php://input"), $data); // Parse incoming PUT data

// Check if the necessary parameters are provided
if (isset($user_id, $data['cart_id'], $data['quantity'])) {
    //$user_id = $data['user_id'];
    $cart_id = $data['cart_id'];
    $quantity = $data['quantity'];
    
    // Validate input
    if (filter_var($user_id, FILTER_VALIDATE_INT) && filter_var($cart_id, FILTER_VALIDATE_INT) && filter_var($quantity, FILTER_VALIDATE_INT)) {
        
        // Check if the cart item belongs to the user and is not checked out
        $query = "SELECT * FROM temp_cart WHERE id = ? AND user_id = ? AND is_checked_out = 0";
        
        if ($stmt = $conn->prepare($query)) {
            $stmt->bind_param("ii", $cart_id, $user_id);
            $stmt->execute();
            $result = $stmt->get_result();
            
            // If the cart item exists and belongs to the user
            if ($result->num_rows > 0) {
                // Update the quantity
                $update_query = "UPDATE temp_cart SET quantity = ? WHERE id = ? AND user_id = ? AND is_checked_out = 0";
                
                if ($update_stmt = $conn->prepare($update_query)) {
                    $update_stmt->bind_param("iii", $quantity, $cart_id, $user_id);
                    $update_stmt->execute();
                    
                    // Check if the update was successful
                    if ($update_stmt->affected_rows > 0) {
                        echo json_encode([
                            'status' => 'success',
                            'message' => 'Cart item quantity updated successfully.',
                        ]);
                    } else {
                        echo json_encode([
                            'status' => 'error',
                            'message' => 'Failed to update cart item quantity.',
                        ]);
                    }
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Failed to prepare update query.',
                    ]);
                }
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Cart item not found or already checked out.',
                ]);
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to prepare the select query.',
            ]);
        }
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Invalid input data.',
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Required fields (user_id, cart_id, quantity) are missing.',
    ]);
}

$conn->close();
?>
