<?php
header("Content-Type: application/json");
require '../dbconn.php'; // Include database connection
$response = ["success" => false];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
    $invoice = isset($_POST['invoice']) ? trim($_POST['invoice']) : '';
    
    if ($id > 0 && !empty($invoice)) {
        // Start a transaction to ensure data integrity
        $conn->begin_transaction();

        try {
            // First, fetch the quote details to get user_id and total_price
            $quote_stmt = $conn->prepare("SELECT user_id, total_price, updated_amount FROM quotes WHERE id = ?");
            $quote_stmt->bind_param("i", $id);
            
            if (!$quote_stmt->execute()) {
                throw new Exception("Failed to fetch quote details");
            }
            
            $quote_result = $quote_stmt->get_result();
            if ($quote_result->num_rows === 0) {
                throw new Exception("Quote not found");
            }
            
            $quote_details = $quote_result->fetch_assoc();
            $quote_stmt->close();

            // Update the invoice field
            $update_stmt = $conn->prepare("UPDATE quotes SET invoice = ? WHERE id = ?");
            $update_stmt->bind_param("si", $invoice, $id);
            
            if (!$update_stmt->execute()) {
                throw new Exception("Failed to update invoice");
            }
            $update_stmt->close();

            // Handle different invoice types
            if (strtolower($invoice) === 'tax invoice') {
                // Delete the quote from quotes table
                $delete_stmt = $conn->prepare("DELETE FROM quotes WHERE id = ?");
                $delete_stmt->bind_param("i", $id);
                
                if (!$delete_stmt->execute()) {
                    throw new Exception("Failed to delete quote");
                }
                $delete_stmt->close();

                $response["message"] = "Tax invoice processed and quote removed";
            } 
            elseif (strtolower($invoice) === 'proforma invoice') {
                // Fetch user details
                $user_stmt = $conn->prepare("SELECT name, email, mobile FROM users WHERE id = ?");
                $user_stmt->bind_param("i", $quote_details['user_id']);
                
                if (!$user_stmt->execute()) {
                    throw new Exception("Failed to fetch user details");
                }
                
                $user_result = $user_stmt->get_result();
                if ($user_result->num_rows === 0) {
                    throw new Exception("User not found");
                }
                
                $user_details = $user_result->fetch_assoc();
                $user_stmt->close();

                // Calculate amounts
                $total_amount = $quote_details['updated_amount'];
                $updated_amount = $quote_details['updated_amount'] ?? $total_amount;
                $paid_amount = 0; // Default to 0, adjust if you have a specific way to calculate paid amount
                $due_amount = $total_amount;

                // Insert into proforma_invoice table
                $proforma_stmt = $conn->prepare("INSERT INTO proforma_invoice (
                    name, 
                    email, 
                    mobile, 
                    total_amount, 
                    paid_amount, 
                    due_amount, 
                    status
                ) VALUES ( ?, ?, ?, ?, ?, ?, ?)");
                
                $status = 'pending';
                $proforma_stmt->bind_param(
                    "sssddds", 
                    $user_details['name'],
                    $user_details['email'],
                    $user_details['mobile'],
                    $total_amount,
                    $paid_amount,
                    $due_amount,
                    $status
                );
                
                if (!$proforma_stmt->execute()) {
                    throw new Exception("Failed to insert proforma invoice");
                }
                $proforma_stmt->close();
                
                // Delete the quote from quotes table (NEW ADDITION)
                $delete_stmt = $conn->prepare("DELETE FROM quotes WHERE id = ?");
                $delete_stmt->bind_param("i", $id);
                
                if (!$delete_stmt->execute()) {
                    throw new Exception("Failed to delete quote");
                }
                $delete_stmt->close();

                $response["message"] = "Proforma invoice created successfully";
                $response["user_details"] = [
                    'name' => $user_details['name'],
                    'email' => $user_details['email'],
                    'mobile' => $user_details['mobile']
                ];
                $response["invoice_details"] = [
                    'total_amount' => $total_amount,
                    'paid_amount' => $paid_amount,
                    'due_amount' => $due_amount,
                    'status' => $status
                ];
            }

            // Commit the transaction
            $conn->commit();
            $response["success"] = true;
        } catch (Exception $e) {
            // Rollback the transaction in case of any error
            $conn->rollback();
            $response["message"] = $e->getMessage();
        }
    } else {
        $response["message"] = "Invalid input";
    }
} else {
    $response["message"] = "Invalid request method";
}

echo json_encode($response);
$conn->close();
?>