<?php
header("Content-Type: application/json");
require '../dbconn.php'; // Include database connection

$response = ["success" => false];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
    $updated_amount = isset($_POST['updated_amount']) ? intval($_POST['updated_amount']) : 0;
    $invoice = isset($_POST['invoice']) ? trim($_POST['invoice']) : '';
    $order_id = isset($_POST['order_id']) ? intval($_POST['order_id']) : 0;
    $paid_amount = isset($_POST['paid_amount']) ? floatval($_POST['paid_amount']) : 0.00;
    $due_amount = isset($_POST['due_amount']) ? floatval($_POST['due_amount']) : 0.00;
    
    if ($order_id > 0 && $paid_amount > 0) {
        $stmt = $conn->prepare("INSERT INTO proforma_invoice (order_id, paid_amount, due_amount) SELECT ?, ?, due_amount - ? FROM proforma_invoice WHERE order_id = ? ORDER BY id DESC LIMIT 1");
        $stmt->bind_param("idii", $order_id, $paid_amount, $paid_amount, $order_id);
        
        if ($stmt->execute()) {
            $response["success"] = true;
            $response["message"] = "New payment record added successfully";
        } else {
            $response["message"] = "Failed to add payment record";
        }
        
        $stmt->close();
    } else {
        $response["message"] = "Invalid input";
    }
} else {
    $response["message"] = "Invalid request method";
}

echo json_encode($response);
?>
