<?php
header("Content-Type: application/json");
require_once '../dbconn.php'; // Include database connection

$response = ["success" => false];

try {
    // Read JSON input
    $data = json_decode(file_get_contents("php://input"), true);

    if (!isset($data['id']) || empty($data['id'])) {
        throw new Exception("Message ID is required.");
    }

    $message_id = intval($data['id']);

    $query = "DELETE FROM help_center_messages WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $message_id);

    if ($stmt->execute()) {
        $response["success"] = true;
        $response["message"] = "Message deleted successfully.";
    } else {
        throw new Exception("Failed to delete the message.");
    }

    $stmt->close();
} catch (Exception $e) {
    $response["message"] = "Error: " . $e->getMessage();
}

echo json_encode($response);
?>
