<?php
header("Content-Type: application/json");
header('Access-Control-Allow-Origin: http://localhost:5173');
// Allow all origins
header('Access-Control-Allow-Methods: GET, POST, OPTIONS'); // Allow specific HTTP methods
header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control'); // Allow specific headers
header('Content-Type: application/json');
require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;




$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    http_response_code(401); // Unauthorized
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);
//$secretKey = "e3ff5f077839c1331b1d893a728246685cb7dba9e3a77bffe7d52eaccf660988";

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null; // Extract user ID from token
    if (!$user_id) {
        http_response_code(400); // Unauthorized
        echo json_encode(['status' => 'error', 'message' => 'Invalid token: user ID not found']);
        exit;
    }
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}

$response = ["success" => false];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    if (!isset($user_id) || !isset($_POST['category']) || !isset($_POST['message'])) {
        $response["message"] = "Missing required fields";
        echo json_encode($response);
        exit;
    }

    //$user_id = intval($_POST['user_id']);
    $category = trim($_POST['category']);
    $message = trim($_POST['message']);

    // Allowed categories
    $allowed_categories = ['order', 'payment', 'service', 'interface', 'others'];

    if ($user_id <= 0 || empty($message) || !in_array($category, $allowed_categories)) {
        $response["message"] = "Invalid input values";
        echo json_encode($response);
        exit;
    }

    $stmt = $conn->prepare("INSERT INTO help_center_messages (user_id, category, message) VALUES (?, ?, ?)");
    $stmt->bind_param("iss", $user_id, $category, $message);

    if ($stmt->execute()) {
        $response["success"] = true;
        $response["message"] = "Message stored successfully";
    } else {
        $response["message"] = "Failed to store message";
    }

    $stmt->close();
}

echo json_encode($response);
?>
