<?php
header("Content-Type: application/json");
require_once "../dbconn.php";

$response = ["success" => false, "message" => ""];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    if (!isset($_POST['order_id'])) {
        $response["message"] = "Order ID is required.";
        echo json_encode($response);
        exit;
    }
    
    $order_id = intval($_POST['order_id']);
    
    // Check if order exists and get current status
    $stmt = $conn->prepare("SELECT order_status FROM orders WHERE id = ?");
    $stmt->bind_param("i", $order_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
        $response["message"] = "Order not found.";
        echo json_encode($response);
        exit;
    }
    
    $order = $result->fetch_assoc();
    $current_status = $order["order_status"];
    
    if ($current_status === "canceled") {
        $response["message"] = "Order is already canceled.";
        echo json_encode($response);
        exit;
    }
    
    // Update order status to canceled
    $update_stmt = $conn->prepare("UPDATE orders SET order_status = 'cancelled' WHERE id = ?");
    $update_stmt->bind_param("i", $order_id);
    
    if ($update_stmt->execute()) {
        // Log status change
        $log_stmt = $conn->prepare("INSERT INTO order_status_history (order_id, old_status, new_status, created_at) VALUES (?, ?, 'canceled', NOW())");
        $log_stmt->bind_param("is", $order_id, $current_status);
        $log_stmt->execute();
        
        $response["success"] = true;
        $response["message"] = "Order canceled successfully.";
    } else {
        $response["message"] = "Failed to cancel order. Please try again.";
    }
} else {
    $response["message"] = "Invalid request method.";
}

echo json_encode($response);
?>
