<?php
// Include the database connection file

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include('../dbconn.php');

header('Access-Control-Allow-Origin: *'); // Allow all origins
header('Access-Control-Allow-Methods: GET, POST, OPTIONS'); // Allow specific HTTP methods
header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control'); // Allow specific headers
header('Content-Type: application/json');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Check if all required fields are provided in the form data
    if (isset($_POST['subcategory_id']) && isset($_POST['material']) && isset($_POST['coating']) && isset($_POST['width']) && isset($_POST['height']) && isset($_POST['slot_width']) && isset($_POST['making'])) {
        // Extract the input data from the form
        $subcategory_id = $_POST['subcategory_id'];
        $material = $_POST['material'];
        $coating = $_POST['coating'];
        $width = $_POST['width'];
        $height = $_POST['height'];
        $slot_width = $_POST['slot_width'];
        $making = $_POST['making'];

        // SQL query to fetch product specifications that match the selected specifications
        $sql = "SELECT * FROM products 
                WHERE sub_category_id = ? 
                AND material = ?
                AND coating = ? 
                AND width = ? 
                AND height = ? 
                AND slot_width = ?
                AND making = ?";

        // Prepare and execute the query
        if ($stmt = $conn->prepare($sql)) {
            // Bind the parameters
            $stmt->bind_param("issssss", $subcategory_id, $material, $coating, $width, $height, $slot_width, $making);

            // Execute the query
            $stmt->execute();
            $result = $stmt->get_result();

            // Check if any specifications are found
            if ($result->num_rows > 0) {
                // Fetch the specifications and return them as JSON
                $specifications = [];
                while ($row = $result->fetch_assoc()) {
                    $specifications[] = $row;
                }
                echo json_encode(["success" => true, "data" => $specifications]);
            } else {
                // Return a message if no specifications are found
                echo json_encode(["success" => false, "message" => "No specifications found for the selected criteria", "data" => []]);
            }

            // Close the statement
            $stmt->close();
        } else {
            echo json_encode(["success" => false, "message" => "Error preparing the SQL query", "data" => []]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "All required parameters are missing", "data" => []]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method", "data" => []]);
}

// Close the database connection
$conn->close();
?>
