<?php
// Include the database connection file
require '../dbconn.php';


// Set response content type
header('Content-Type: application/json');

// Initialize response
$response = [];

// Fetch categories from the database
$sql = "SELECT id, name, image_url, description FROM categories";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Fetch all rows as an associative array
    $categories = [];
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row;
    }
    // Success response
    $response = [
        'status' => 'success',
        'data' => $categories
    ];
} else {
    // No categories found
    $response = [
        'status' => 'error',
        'message' => 'No categories found'
    ];
}

// Close the database connection
$conn->close();

// Output the response in JSON format
echo json_encode($response);
?>
