<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include the database connection file
include('../dbconn.php');


// Check if subcategory_id is provided in the URL
if (isset($_GET['subcategory_id'])) {
    $subcategory_id = intval($_GET['subcategory_id']);
    $page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1; // Default page 1
    $limit = isset($_GET['limit']) ? max(1, intval($_GET['limit'])) : 100; // Default limit 10
    $offset = ($page - 1) * $limit;
    $search = isset($_GET['search']) ? trim($_GET['search']) : "";
    $material = isset($_GET['material']) ? trim($_GET['material']) : "";
    $making = isset($_GET['making']) ? trim($_GET['making']) : "";
    $coating = isset($_GET['coating']) ? trim($_GET['coating']) : "";

    // Initialize response
    $response = [
        "success" => false,
        "message" => "No products found",
        "total_count" => 0,
        "page" => $page,
        "limit" => $limit,
        "data" => []
    ];

    // Base query for counting products
    $count_query = "SELECT COUNT(*) as total FROM products WHERE sub_category_id = ?";
    $query_conditions = [];
    $params = ["i", &$subcategory_id];

    if (!empty($search)) {
        $count_query .= " AND name LIKE ?";
        $search_param = "%$search%";
        $query_conditions[] = &$search_param;
        $params[0] .= "s";
    }
    if (!empty($material)) {
        $count_query .= " AND material = ?";
        $query_conditions[] = &$material;
        $params[0] .= "s";
    }
    if (!empty($making)) {
        $count_query .= " AND making = ?";
        $query_conditions[] = &$making;
        $params[0] .= "s";
    }
    if (!empty($coating)) {
        $count_query .= " AND coating = ?";
        $query_conditions[] = &$coating;
        $params[0] .= "s";
    }

    if ($count_stmt = $conn->prepare($count_query)) {
        if (count($query_conditions) > 0) {
            $count_stmt->bind_param(...array_merge($params, $query_conditions));
        } else {
            $count_stmt->bind_param("i", $subcategory_id);
        }
        $count_stmt->execute();
        $count_result = $count_stmt->get_result();
        $total_count = $count_result->fetch_assoc()['total'];
        $count_stmt->close();
    } else {
        echo json_encode(["success" => false, "message" => "Error preparing count query"]);
        exit;
    }

    $sql = "SELECT * FROM products WHERE sub_category_id = ?";
    
    // Build the types string and params array
    $types = "i"; // Start with integer for subcategory_id
    $params = [$subcategory_id];

    if (!empty($search)) {
        $sql .= " AND name LIKE ?";
        $types .= "s";
        $params[] = "%$search%";
    }
    if (!empty($material)) {
        $sql .= " AND material = ?";
        $types .= "s";
        $params[] = $material;
    }
    if (!empty($making)) {
        $sql .= " AND making = ?";
        $types .= "s";
        $params[] = $making;
    }
    if (!empty($coating)) {
        $sql .= " AND coating = ?";
        $types .= "s";
        $params[] = $coating;
    }

    // Add LIMIT and OFFSET parameters
    $sql .= " LIMIT ? OFFSET ?";
    $types .= "ii";
    $params[] = $limit;
    $params[] = $offset;

    if ($stmt = $conn->prepare($sql)) {
        // Create array with types as first element followed by params
        $bind_params = array_merge([$types], $params);
        
        // Use spread operator to pass array elements as separate parameters
        $stmt->bind_param(...$bind_params);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $products = [];
            while ($row = $result->fetch_assoc()) {
                $products[] = $row;
            }

            // Update response
            $response = [
                "success" => true,
                "message" => "Products fetched successfully",
                "total_count" => $total_count,
                "page" => $page,
                "limit" => $limit,
                "data" => $products
            ];
        }

        $stmt->close();
    } else {
        echo json_encode(["success" => false, "message" => "Error preparing SQL query"]);
        exit;
    }

    // Return response as JSON
    echo json_encode($response);
} else {
    echo json_encode(["success" => false, "message" => "subcategory_id parameter is missing"]);
}

// Close the database connection
$conn->close();
?>