<?php
// Include database connection
include '../dbconn.php';

// header('Access-Control-Allow-Origin: *'); // Allow all origins
// header('Access-Control-Allow-Methods: GET, POST, OPTIONS'); // Allow specific HTTP methods
// header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control'); // Allow specific headers
header('Content-Type: application/json');

// Get category_id from URL
$subcategory_id = isset($_GET['category_id']) ? intval($_GET['category_id']) : 0;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1; // Default to page 1
$limit = isset($_GET['limit']) ? max(1, intval($_GET['limit'])) : 100; // Default limit to 10
$offset = ($page - 1) * $limit;
$search = isset($_GET['search']) ? trim($_GET['search']) : "";

// Initialize response
$response = [
    "status" => "error",
    "message" => "Invalid subcategory ID",
    "total_count" => 0,
    "page" => $page,
    "limit" => $limit,
    "data" => []
];

// Check if category_id is valid
if ($subcategory_id > 0) {
    // Count total products for pagination
    $count_query = "SELECT COUNT(*) as total FROM sub_categories WHERE category_id = ? AND deleted=0";
    if (!empty($search)) {
        $count_query .= " AND name LIKE ?";
    }
    $count_stmt = $conn->prepare($count_query);
    
    if (!empty($search)) {
        $search_param = "%$search%";
        $count_stmt->bind_param("is", $subcategory_id, $search_param);
    } else {
        $count_stmt->bind_param("i", $subcategory_id);
    }

    $count_stmt->execute();
    $count_result = $count_stmt->get_result();
    $total_count = $count_result->fetch_assoc()['total'];
    $count_stmt->close();

    // Prepare SQL query with pagination and search
   $sql = "
        SELECT
  sc.id,
  sc.name,
  sc.image_url,
  sc.description,
  EXISTS (
    SELECT 1
    FROM products p
    WHERE p.sub_category_id = sc.id
  ) AS has_products
FROM sub_categories sc
WHERE sc.category_id = ? AND deleted=0
";
    
    if (!empty($search)) {
        $sql .= " AND name LIKE ?";
    }
    $sql .= " LIMIT ? OFFSET ?";

    if ($stmt = $conn->prepare($sql)) {
        if (!empty($search)) {
            $stmt->bind_param("isii", $subcategory_id, $search_param, $limit, $offset);
        } else {
            $stmt->bind_param("iii", $subcategory_id, $limit, $offset);
        }

        // Execute the query
        $stmt->execute();
        $result = $stmt->get_result();

        // Check if products exist
        if ($result->num_rows > 0) {
            $products = [];
            while ($row = $result->fetch_assoc()) {
                $products[] = $row;
            }

            // Update response
            $response = [
                "status" => "success",
                "message" => "Products fetched successfully",
                "total_count" => $total_count,
                "page" => $page,
                "limit" => $limit,
                "data" => $products
            ];
        } else {
            $response["message"] = "No products found for the given subcategory ID";
            $response["total_count"] = $total_count;
        }

        // Close the statement
        $stmt->close();
    } else {
        $response["message"] = "Failed to prepare the SQL statement";
    }
}

// Output the response as JSON
echo json_encode($response);

// Close the database connection
$conn->close();
?>
