<?php
require '../dbconn.php';

if ($_SERVER["REQUEST_METHOD"] === "DELETE") {
    parse_str(file_get_contents("php://input"), $_DELETE);
    $user_id = $_DELETE['user_id'] ?? 0;

    if (!$user_id) {
        echo json_encode(["success" => false, "message" => "User ID is required"]);
        exit;
    }

    // Check if user has an active cart (not checked out)
    $stmt = $conn->prepare("SELECT COUNT(*) FROM temp_cart WHERE user_id = ? AND is_checked_out = 0");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->bind_result($cart_count);
    $stmt->fetch();
    $stmt->close();

    if ($cart_count == 0) {
        echo json_encode(["success" => false, "message" => "No active cart found for this user"]);
        exit;
    }

    // If promocodes are stored in a separate table, delete the record from there
    $stmt = $conn->prepare("DELETE FROM cart_promocodes WHERE user_id = ?");
    $stmt->bind_param("i", $user_id);
    
    if ($stmt->execute()) {
        // Recalculate cart total price (removing discount)
        $stmt = $conn->prepare("UPDATE temp_cart SET unit_price = original_price WHERE user_id = ? AND is_checked_out = 0");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();

        echo json_encode(["success" => true, "message" => "Promocode removed successfully, cart updated"]);
    } else {
        echo json_encode(["success" => false, "message" => "Failed to remove promocode"]);
    }

    $stmt->close();
    $conn->close();
}
