<?php
require '../dbconn.php';

if ($_SERVER["REQUEST_METHOD"] === "GET") {
    $promocode_id = $_GET['id'] ?? 0;

    if (!$promocode_id) {
        echo json_encode(["success" => false, "message" => "Promocode ID is required"]);
        exit;
    }

    $stmt = $conn->prepare("SELECT * FROM promocode_usage WHERE promocode_id = ?");
    $stmt->bind_param("i", $promocode_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $usage_data = [];
    while ($row = $result->fetch_assoc()) {
        $usage_data[] = $row;
    }

    echo json_encode(["success" => true, "data" => $usage_data]);

    $stmt->close();
    $conn->close();
}
?>
