<?php
require '../dbconn.php';

if ($_SERVER["REQUEST_METHOD"] === "PUT") {
    parse_str(file_get_contents("php://input"), $_PUT);
    
    $promocode_id = $_PUT['id'] ?? 0;
    $is_active = $_PUT['is_active'] ?? 1;
    $valid_until = $_PUT['valid_until'] ?? '';
    $usage_limit = $_PUT['usage_limit'] ?? 0;

    if (!$promocode_id) {
        echo json_encode(["success" => false, "message" => "Promocode ID is required"]);
        exit;
    }

    $stmt = $conn->prepare("UPDATE promocodes SET is_active = ?, valid_until = ?, usage_limit = ? WHERE id = ?");
    $stmt->bind_param("isdi", $is_active, $valid_until, $usage_limit, $promocode_id);
    
    if ($stmt->execute()) {
        echo json_encode(["success" => true, "message" => "Promocode updated successfully"]);
    } else {
        echo json_encode(["success" => false, "message" => "Failed to update promocode"]);
    }

    $stmt->close();
    $conn->close();
}
?>
