<?php
require '../dbconn.php';

// Allow CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

$id = $_POST['id'] ?? null;

if (!$id) {
    echo json_encode(['status' => 'error', 'message' => 'Shipping address ID is required']);
    exit;
}

$fields_to_update = [];

$possible_fields = [
    'first_name', 'last_name', 'phone_number', 'pincode', 
    'flat_building', 'area_street', 'landmark', 'city', 'state', 'country'
];

foreach ($possible_fields as $field) {
    if (isset($_POST[$field])) {
        $fields_to_update[$field] = $conn->real_escape_string($_POST[$field]);
    }
}

if (empty($fields_to_update)) {
    echo json_encode(['status' => 'error', 'message' => 'No fields provided to update']);
    exit;
}

$update_query = "UPDATE shipping_addresses SET ";
$update_parts = [];
foreach ($fields_to_update as $field => $value) {
    $update_parts[] = "$field = '$value'";
}
$update_query .= implode(', ', $update_parts);
$update_query .= " WHERE id = '$id'";

if ($conn->query($update_query) === TRUE) {
    echo json_encode(['status' => 'success', 'message' => 'Shipping address updated successfully']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Error updating shipping address: ' . $conn->error]);
}

$conn->close();
?>
